import time
import pygame
import random
import pygame.mixer
pygame.mixer.init()
diesound = pygame.mixer.Sound("Data/Die.wav")
winsound = pygame.mixer.Sound("Data/Complete.wav")
freezesound = pygame.mixer.Sound("Data/Freeze.wav")
glasssound = pygame.mixer.Sound("Data/Hourglass.wav")

from OpenGL.GL import *
from OpenGL.GLU import *

class object:
  def __init__(self,x=0,y=0,spin=0):
    self.fx = float(x)
    self.fy = float(y)
    self.x = x
    self.y = y
    self.spin = spin
    
class timer:
  def __init__(self):
    self.frequency = 1000
    self.resolution = 1./1000.
    self.mm_timer_start = time.clock()
    self.mm_timer_elapsed = self.mm_timer_start
  def gettime(self):
    ctime = time.clock()
    return float(ctime-self.mm_timer_start)*self.resolution*1000*1000
    
class Texture:
  def __init__(self,filename,filter=GL_LINEAR):
    self.name = filename
    img = pygame.image.load("Data/"+filename+".bmp")
    self.w = img.get_width()
    self.h = img.get_height()
    idat = pygame.image.tostring(img,"RGB",True)
    del img
    self.texname = glGenTextures(1)
    glBindTexture(GL_TEXTURE_2D,self.texname)
    glTexImage2D(GL_TEXTURE_2D,0,3,self.w,self.h,0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,filter)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,filter)
  def bind(self):
    glBindTexture(GL_TEXTURE_2D,self.texname)
    
def buildfont(texture):
  base = glGenLists(256)
  texture.bind()
  for i in range(256):
    cx = i%16/16.
    cy = i/16/16.
    glNewList(base+i,GL_COMPILE)
    glBegin(GL_QUADS)
    glTexCoord2d(cx,1-cy-.0625); glVertex2i(0,16)
    glTexCoord2d(cx+.0625,1-cy-.0625); glVertex2i(16,16)
    glTexCoord2d(cx+.0625,1-cy); glVertex2i(16,0)
    glTexCoord2d(cx,1-cy); glVertex2i(0,0)
    glEnd()
    glTranslated(15,0,0)
    glEndList()
  return base
def printf(x,y,set,text,base):
  glEnable(GL_TEXTURE_2D)
  glLoadIdentity()
  glTranslated(x,y,0)
  wrap = base-32+(set*128)
  if wrap<0: wrap += 128
  glListBase(wrap)
  if set==0:
    glScalef(1.5,2,1)
  glCallLists(text)
  glDisable(GL_TEXTURE_2D)

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 21 - simple game"
    self.glinited = False
    
    self.makegrid()
    
    #gamestate
    self.gameover = False
    self.anti = True
    self.active = True
    self.filled = False
    
    #enemy move delay
    self.delay = 0
    self.adjust = 3  #speed up enemies if slow framerate
    self.lives = 5
    self.level = 1  #starting difficulty
    self.level2 = self.level #increasing difficulty
    self.stage = 1 #The stage we are on
    
    #objects
    self.player = object()
    self.enemies = [object() for i in range(9)]
    self.hourglass = object()
    self.steps = [1,2,4,5,10,20]  #different speeds for different computers
    
    #textures
    self.textures = {}
    self.fontbase = 0
  def makegrid(self):
    #lines for grid
    self.vline = [[0 for x in range(11)] for y in range(11)]
    self.hline = [[0 for x in range(11)] for y in range(11)]
  def resetobjects(self):
    self.player.x = 0
    self.player.y = 0
    self.player.fx = 0
    self.player.fy = 0
    for e in self.enemies:
      e.x = int(5+random.random()*6)
      e.y = int(random.random()*11)
      e.fx = e.x*60
      e.fy = e.y*40
  def loadTextures(self):
    for t in "Font","Image":
      if not self.textures.has_key(t):
        tex = Texture(t)
        self.textures[t] = tex
    self.texloaded = True
    print self.textures
  def initGL(self):
    self.loadTextures()
    self.base = buildfont(self.textures["Font"])
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glHint(GL_LINE_SMOOTH_HINT,GL_NICEST)
    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA)
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glOrtho(0,wi,hi,0,-1,1)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def update(self):
    keys = pygame.key.get_pressed()
    sp = self.steps[self.adjust]
    if not self.gameover and self.active:
      for i in range(self.level*self.stage):
        e = self.enemies[i]
        if e.x<self.player.x and e.fy == e.y*40:
          e.x+=1
        if e.x>self.player.x and e.fy == e.y*40:
          e.x-=1
        if e.y<self.player.y and e.fx == e.x*60:
          e.y+=1
        if e.y>self.player.y and e.fx == e.x*60:
          e.y-=1
      if (self.delay>(3-self.level)) and self.hourglass.fx!=2:
        self.delay = 0
        for i in range(self.level*self.stage):
          e = self.enemies[i]
          if e.fx<e.x*60:
            e.fx+=sp
            e.spin+=sp
          if e.fx>e.x*60:
            e.fx-=sp
            e.spin-=sp
          if e.fy<e.y*40:
            e.fy+=sp
            e.spin-=sp
          if e.fy>e.y*60:
            e.fy-=sp
            e.spin+=sp
          if e.fx==self.player.fx and e.fy==self.player.fy:
            self.lives -= 1
            if self.lives == 0:
              self.gameover = True
            self.resetobjects()
            diesound.play()
            while pygame.mixer.get_busy(): pass
      atpoint = self.player.fx == self.player.x*60 and self.player.fy == self.player.y*40
      if atpoint:
        if keys[pygame.K_RIGHT] and self.player.x<10:
          self.hline[self.player.x][self.player.y]=True
          self.player.x+=1
        if keys[pygame.K_LEFT] and self.player.x>0:
          self.player.x-=1
          self.hline[self.player.x][self.player.y]=True
        if keys[pygame.K_UP] and self.player.y>0:
          self.player.y-=1
          self.vline[self.player.x][self.player.y]=True
        if keys[pygame.K_DOWN] and self.player.y<10:
          self.vline[self.player.x][self.player.y]=True
          self.player.y+=1
      if self.player.fx<self.player.x*60:
        self.player.fx+=sp
      if self.player.fx>self.player.x*60:
        self.player.fx-=sp
      if self.player.fy<self.player.y*40:
        self.player.fy+=sp
      if self.player.fy>self.player.y*40:
        self.player.fy-=sp
      #hit hourglass
      if self.player.fy == self.hourglass.y*40 and self.player.fx == self.hourglass.x*60 and self.hourglass.fx == 1:
        freezesound.play(-1)
        self.hourglass.fx=2
        self.hourglass.fy=0
      self.player.spin+=.5*sp
      if self.player.spin>360:
        self.player.spin-=360
      self.hourglass.spin-=.25*sp
      if self.hourglass.spin<0:
        self.hourglass.spin+=360
      self.hourglass.fy+=sp
      if self.hourglass.fx==0 and self.hourglass.fy>6000/self.level:
        glasssound.play()
        self.hourglass.x = int(random.random()*10)+1
        self.hourglass.y = int(random.random()*11)
        self.hourglass.fx = 1
        self.hourglass.fy = 0
      if self.hourglass.fx==1 and self.hourglass.fy>6000/self.level:
        self.hourglass.fx=0
        self.hourglass.fy = 0
      if self.hourglass.fx==2 and self.hourglass.fy>500+500*self.level:
        self.hourglass.fx = 0
        self.hourglass.fy = 0
        freezesound.stop()
      self.delay+=1
    else:
      if keys[pygame.K_SPACE]:
        self.gameover = False
        self.filled = True
        self.level = 1
        self.level2 = 1
        self.stage = 0
        self.lives = 5
    if self.filled:
      freezesound.stop()
      winsound.play()
      while pygame.mixer.get_busy(): pass
      self.stage += 1
      if self.stage>3:
        self.stage = 1
        self.level += 1
        self.level2 += 1
        if self.level>3:
          self.level = 3
          self.lives += 1
          if self.lives>5:
            self.lives = 5
      self.resetobjects()
      self.makegrid()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    self.textures["Font"].bind()
    glColor3f(1,.5,1) #purple
    printf(207,24,0,"GRID CRAZY",self.base)
    glColor3f(1,1,0) #yellow
    printf(20,20,1,"Level:%d"%self.level2,self.base)
    printf(20,40,1,"Stage:%d"%self.stage,self.base)
    if self.gameover:
      glColor3f(random.random(),random.random(),random.random())
      printf(472,20,1,"GAME OVER",self.base)
      printf(472,40,1,"PRESS SPACE",self.base)
    #players lives
    for i in range(self.lives-1):
      glLoadIdentity()
      glTranslated(490+i*40,40,0)
      glRotatef(-self.player.spin,0,0,1)
      glColor3f(0,1,0)  #green
      glBegin(GL_LINES)
      glVertex2d(-5,-5)
      glVertex2d(5,5)
      glVertex2d(5,-5)
      glVertex2d(-5,5)
      glEnd()
      glRotatef(-self.player.spin*.5,0,0,1)
      glColor3f(0,.75,0) #dark green
      glBegin(GL_LINES)
      glVertex2d(-7,0)
      glVertex2d(7,0)
      glVertex2d(0,-7)
      glVertex2d(0,7)
      glEnd()
    #grid
    self.filled = True
    glLineWidth(2)
    #glDisable(GL_LINE_SMOOTH)
    glLoadIdentity()
    for x in range(11):
      for y in range(11):
        glColor3f(0,.5,1)
        if self.hline[x][y]:
          glColor3f(1,1,1)
        if x<10:
          if not self.hline[x][y]:
            self.filled = False
          glBegin(GL_LINES)
          glVertex2d(20+x*60,70+y*40)
          glVertex2d(80+x*60,70+y*40)
          glEnd()
        glColor3f(0,.5,1)
        if self.vline[x][y]:
          glColor3f(1,1,1)
        if y<10:
          if not self.vline[x][y]:
            self.filled = False
          glBegin(GL_LINES)
          glVertex2d(20+x*60,70+y*40)
          glVertex2d(20+x*60,110+y*40)
          glEnd()
        #Filled squares
        glEnable(GL_TEXTURE_2D)
        glColor3f(1,1,1)
        self.textures["Image"].bind()
        if x<10 and y<10:
          if self.hline[x][y] and self.hline[x][y+1] and self.vline[x][y] and self.vline[x+1][y]:
            glBegin(GL_QUADS)
            glTexCoord2f(x/10.+.1,1-y/10.); glVertex2d(20+x*60+59,70+y*40+1)
            glTexCoord2f(x/10.,1-y/10.); glVertex2d(20+x*60,70+y*40+1)
            glTexCoord2f(x/10.,1-y/10.+.1); glVertex2d(20+x*60,70+y*40+39)
            glTexCoord2f(x/10.+.1,1-y/10.+.1); glVertex2d(20+x*60+59,70+y*40+39)
            glEnd()
        glDisable(GL_TEXTURE_2D)
    glLineWidth(1)
    if self.anti:
      glEnable(GL_LINE_SMOOTH)
    else:
      glDisable(GL_LINE_SMOOTH)
    #hourglass
    if self.hourglass.fx==1:
      glLoadIdentity()
      glTranslatef(20+self.hourglass.x*60,70+self.hourglass.y*40,0)
      glRotatef(self.hourglass.spin,0,0,1)
      glColor3f(random.random(),random.random(),random.random())
      glBegin(GL_LINES)
      glVertex2d(-5,-5)
      glVertex2d(5,5)
      glVertex2d(5,-5)
      glVertex2d(-5,5)
      glVertex2d(-5,-5)
      glVertex2d(5,-5)
      glVertex2d(-5,5)
      glVertex2d(5,5)
      glEnd()
    #player
    glLoadIdentity()
    glTranslatef(20+self.player.fx,70+self.player.fy,0)
    glRotatef(self.player.spin,0,0,1)
    glColor3f(0,1,0)
    glBegin(GL_LINES)
    glVertex2d(-5,-5)
    glVertex2d(5,5)
    glVertex2d(-5,5)
    glVertex2d(5,-5)
    glEnd()
    glRotatef(self.player.spin*.5,0,0,1)
    glColor3f(0,.75,0)
    glBegin(GL_LINES)
    glVertex2d(-7,0)
    glVertex2d(7,0)
    glVertex2d(0,-7)
    glVertex2d(0,7)
    glEnd()
    for i in range(self.stage*self.level):
      e = self.enemies[i]
      glLoadIdentity()
      glTranslatef(20+e.fx,70+e.fy,0)
      glColor3f(1,.5,.5)
      glBegin(GL_LINES)
      glVertex2d(0,-7)
      glVertex2d(-7,0)
      glVertex2d(-7,0)
      glVertex2d(0,7)
      glVertex2d(0,7)
      glVertex2d(7,0)
      glVertex2d(7,0)
      glVertex2d(0,-7)
      glEnd()
      glRotatef(e.spin,0,0,1)
      glColor3f(1,0,0)
      glBegin(GL_LINES)
      glVertex2d(-7,-7)
      glVertex2d(7,7)
      glVertex2d(-7,7)
      glVertex2d(7,-7)
      glEnd()

screen = Screen()
screen.resize()
screen.resetobjects()
t = timer()

running = 1
while running:
  start = t.gettime()
  screen.draw()
  pygame.display.flip()
  while t.gettime()<start+float(screen.steps[screen.adjust]*2): pass
  screen.update()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
      if e.key==pygame.K_a:
        screen.anti = not screen.anti
        
